/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.Iterators;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSpout;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.MutableContainerItemContext;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.createmod.catnip.platform.CatnipServices;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class SpoutCategory
extends CreateRecipeCategory<FillingRecipe> {
    private final AnimatedSpout spout = new AnimatedSpout();

    public SpoutCategory(CreateRecipeCategory.Info<FillingRecipe> info) {
        super(info);
    }

    public static void consumeRecipes(Consumer<FillingRecipe> consumer, IIngredientManager ingredientManager) {
        List<FluidStack> fluidStacks = ingredientManager.getAllIngredients((IIngredientType)FabricTypes.FLUID_STACK).stream().map(CreateRecipeCategory::fromJei).toList();
        for (class_1799 stack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (PotionFluidHandler.isPotionItem(stack)) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                class_1856 bottle = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8469});
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("potions")).withItemIngredients(bottle).withFluidIngredients(FluidIngredient.fromFluidStack(fluidFromPotionItem)).withSingleItemOutput(stack).build());
                continue;
            }
            Storage storage = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
            if (storage == null) continue;
            int numTanks = Iterators.size((Iterator)storage.iterator());
            FluidStack existingFluid = numTanks == 1 ? new FluidStack((StorageView)storage.iterator().next()) : FluidStack.EMPTY;
            for (FluidStack fluidStack : fluidStacks) {
                if (numTanks == 1 && !existingFluid.isEmpty() && !existingFluid.isFluidEqual(fluidStack)) continue;
                class_1799 copy = stack.method_7972();
                MutableContainerItemContext context = new MutableContainerItemContext(stack);
                Storage copyStorage = (Storage)context.find(FluidStorage.ITEM);
                if (copyStorage == null || !GenericItemFilling.isFluidHandlerValid(copy, (Storage<FluidVariant>)copyStorage)) continue;
                FluidStack fluidCopy = fluidStack.copy();
                fluidCopy.setAmount(81000L);
                TransferUtil.insertFluid((Storage)copyStorage, (FluidStack)fluidStack);
                class_1799 container = context.getItemVariant().toStack(TransferUtil.truncateLong((long)context.getAmount()));
                if (ItemHelper.sameItem(container, copy) || container.method_7960()) continue;
                class_1856 bucket = class_1856.method_8101((class_1799[])new class_1799[]{stack});
                class_2960 itemName = CatnipServices.REGISTRIES.getKeyOrThrow(stack.method_7909());
                class_2960 fluidName = CatnipServices.REGISTRIES.getKeyOrThrow(fluidCopy.getFluid());
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("fill_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832())).withItemIngredients(bucket).withFluidIngredients(FluidIngredient.fromFluidStack(fluidCopy)).withSingleItemOutput(container).build());
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FillingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addIngredients((class_1856)recipe.method_8117().get(0));
        SpoutCategory.addFluidSlot(builder, 27, 32, recipe.getRequiredFluid());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addItemStack(SpoutCategory.getResultItem(recipe));
    }

    public void draw(FillingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 126, 29);
        this.spout.withFluids(recipe.getRequiredFluid().getMatchingFluidStacks()).draw(graphics, this.getBackground().getWidth() / 2 - 13, 22);
    }
}

